clear all
set more off
set type double

********************************************************************************
********************************************************************************
********************************************************************************
**** STATA Guide
**** Building the SDG economy: Needs, spending, and financing for universal achievement of the Sustainable Development Goals
**** Homi Kharas & John McArthur
**** Final data and do-files compiled by Selen Özdoğan
**** October 2019
********************************************************************************
********************************************************************************
********************************************************************************

*** 0. Define a program to clean country names
do "dofiles\0_country_rename.do"

*** 1. Estimate public spending on the SDG Economy
***		Main output datasets: "merged_full_totals_cons.dta", "spending with alt.dta", "spending plus DRM ODA.dta
do "dofiles\1_SDG_spending_clean.do"

*** 2. Estimate public spending needs to achieve the SDG economy in 2025
***		Main output dataset: "needs_combine_full_cons.dta"
do "dofiles\2_SDG_needs_clean.do"

*** 3. Estimate needs gaps between SDG public spending needs and projected expenditures in 2025
***		Main output dataset: "gaps.dta"
do "dofiles\3_SDG_needs_gap_clean.do"

*** 4. Replicate figures and tables
do "dofiles\4_Figures_and_tables_clean.do"

